<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title><?php echo $__env->yieldContent('title'); ?></title>
        <link rel="shortcut icon" href="<?php echo e(asset('frontend/images/logo.svg')); ?>">
        <link href="<?php echo e(asset('admin/css/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('css/styles.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" crossorigin="anonymous" />
        <script src="<?php echo e(asset('js/all.min.js')); ?>" crossorigin="anonymous"></script>
        <link rel="stylesheet" href="<?php echo e(asset('css/toastr.css')); ?>"crossorigin="anonymous" />
        <link href="<?php echo e(asset('assets/plugins/bootstrap-datatable/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css">
        <link href="<?php echo e(asset('assets/plugins/bootstrap-datatable/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css">

        <style>
            @media  print {
            #hideButton {
                display: none;
            }
            }
        </style>
</head>
    <body class="sb-nav-fixed">
        <?php echo $__env->make('admin.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div id="layoutSidenav">
            <div id="layoutSidenav_nav">
                <?php echo $__env->make('admin.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div id="layoutSidenav_content">
                <main>
                    <?php echo $__env->yieldContent('maincontent'); ?>
                </main>
                <?php echo $__env->make('admin.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
           
        </div>
        <script src="<?php echo e(asset('js/jquery-3.5.1.min.js')); ?>" crossorigin="anonymous"></script>
        <script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>" crossorigin="anonymous"></script>
        <script src="<?php echo e(asset('js/scripts.js')); ?>"></script>
        <script src="<?php echo e(asset('js/Chart.min.js')); ?>" crossorigin="anonymous"></script>
        <script src="<?php echo e(asset('assets/demo/chart-area-demo.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/demo/chart-bar-demo.js')); ?>"></script>
        <script src="<?php echo e(asset('js/toastr.min.js')); ?>" crossorigin="anonymous"></script>
       
        <script>
            <?php if(Session::has('success')): ?>
                toastr.success('<?php echo e(Session::get("success")); ?>');
            <?php endif; ?>
            <?php if(Session::has('info')): ?>
                toastr.info('<?php echo e(Session::get("info")); ?>');
            <?php endif; ?>
            <?php if(Session::has('error')): ?>
                toastr.error('<?php echo e(Session::get("error")); ?>');
            <?php endif; ?>
            <?php if(Session::has('warnign')): ?>
                toastr.warning('<?php echo e(Session::get("warning")); ?>');
            <?php endif; ?>
        </script>
        <!--Data Tables js-->
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/jquery.dataTables.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/dataTables.bootstrap4.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/dataTables.buttons.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/buttons.bootstrap4.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/jszip.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/pdfmake.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/vfs_fonts.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/buttons.html5.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/buttons.print.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/plugins/bootstrap-datatable/js/buttons.colVis.min.js')); ?>"></script>
  <script src="<?php echo e(asset('js/salary.js')); ?>"></script>
  <script src="<?php echo e(asset('js/night.js')); ?>"></script>
  <script src="<?php echo e(asset('js/multidatespicker.js')); ?>" type="text/javascript"></script>
  <link href="<?php echo e(asset('css/select.css')); ?>" rel="stylesheet" />
  <script src="<?php echo e(asset('js/select.js')); ?>"></script>
  <script>
    $(document).ready(function () {
      //Default data table
      $('#default-datatable').DataTable();
      var table = $('#example').DataTable({
        lengthChange: false,
        buttons: ['copy', 'excel', 'pdf', 'print', 'colvis']
      });
      table.buttons().container()
        .appendTo('#example_wrapper .col-md-6:eq(0)');

    });





$(document).ready(function() {
  const monthNames = ["January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
  ];
  let qntYears = 4;
  let selectYear = $("#year_night");
  let selectMonth = $("#month_night");
  let selectDay = $("#day");
  let currentYear = new Date().getFullYear();

  for (var y = 0; y < qntYears; y++) {
    let date = new Date(currentYear);
    let yearElem = document.createElement("option");
    yearElem.value = currentYear
    yearElem.textContent = currentYear;
    selectYear.append(yearElem);
    currentYear--;
  }

  for (var m = 0; m < 12; m++) {
    let month = monthNames[m];
    let monthElem = document.createElement("option");
    monthElem.value = m;
    monthElem.textContent = month;
    selectMonth.append(monthElem);
  }

  var d = new Date();
  var month = d.getMonth();
  var year = d.getFullYear();
  var day = d.getDate();

  selectYear.val(year);
  selectYear.on("change", AdjustDays);
  selectMonth.val(month);
  selectMonth.on("change", AdjustDays);

  AdjustDays();
  selectDay.val(day)

  function AdjustDays() {
    var year = selectYear.val();
    var month = parseInt(selectMonth.val()) + 1;
    selectDay.empty();

    //get the last day, so the number of days in that month
    var days = new Date(year, month, 0).getDate();

    //lets create the days of that month
    for (var d = 1; d <= days; d++) {
      var dayElem = document.createElement("option");
      dayElem.value = d;
      dayElem.textContent = d;
      selectDay.append(dayElem);
    }
  }

});

  </script>

  <?php echo $__env->yieldContent('custom_js'); ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\automation\resources\views/admin/master.blade.php ENDPATH**/ ?>