

<?php $__env->startSection('title'); ?>

<?php
if(isset($from_date)){
    echo "WFS Profit Report ".$from_date." To ".$to_date;
}else{
    echo "WFS Profit Report";
}
?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid">
    <div class="card mb-2 mt-4 p-2">
        <section id="main-content" style="margin: auto;">
            <div class="form-row show-inputbtns" align="center">
                <form action="<?php echo e(url('profit/reports')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input name="from_date" type="date" id="from_date" /> To
                    <input name="to_date" type="date" id="to_date" />
                    <input name="submit" type="submit" value="Report" class="btn btn-sm btn-dark"/>
                </form>
                
            </div>
        </section>
    </div>
      
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> WFS orders Profit</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Date</th>
                        <th>Order#</th>
                        <th>Buyer Name</th>
                        <th>Item Name</th>
                        <th>Sold Qty</th>
                        <th>Walmart Price</th>
                        <th>Sourcing Cost</th>
                        <th>WFS Fee</th>
                        <th>Walmart Fee</th>
                        <th>Profit</th>
                        <th>ROI</th>
                        <th>Status</th>
                        
                    </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $inTotalSoldQty       = 0;
                        $inTotalWalmartPrice  = 0;
                        $inTotalWalmartFee    = 0;
                        $inTotalWFSFee        = 0;
                        $inTotalSourcingCost  = 0;
                        $inTotalROI           = 0;
                        $inTotalProfit        = 0;
                        $profit               = 0;
                        $sourcingCost         = 0;
                      ?>

                        <?php if(!empty($response)): ?>
                        <?php $__currentLoopData = $response; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php

                


                        $soldQty        = $value->sold_qty;
                        $walmartPrice   = $value->walmart_price *   $soldQty ;

                        $item_qty         = $value->item_qty * $soldQty;
                        $line_total       = $value->line_total* $soldQty;
                        
                        $price_per_unit    = $line_total/$item_qty;

                        $ship_prep_cost    = $value->ship_prep_cost* $soldQty;
                        $other_cost        = $value->other_cost* $soldQty;
                        $wfs_cost          = $value->wfs_cost* $soldQty;
                        

                        $totalItemCost = ($line_total+$ship_prep_cost+$other_cost+$wfs_cost)*$soldQty;
                       
                        
                        $sourcingCost = round($totalItemCost/$item_qty,2);

                        $wfsFee         = $value->wfs_fee* $soldQty;



                        $wfc            = ($walmartPrice*0.15);
                        $walmartFee     = round($wfc,2);
                        $profit         = $walmartPrice-($walmartFee+$sourcingCost+$wfsFee);

                        if(empty($sourcingCost)){
                          $profitROI = 0;
                        }else{
                          $t =($profit/$sourcingCost)*100;
                        $profitROI      =  round($t,2);

                        }

                        //inTotal Calculate

                        $inTotalSoldQty         +=  $soldQty;
                        $inTotalWalmartPrice    +=  $walmartPrice;
                        $inTotalWalmartFee      +=  $walmartFee;
                        $inTotalProfit          +=  $profit;
                        $inTotalWFSFee          +=  $wfsFee;
                        $inTotalSourcingCost    +=  $sourcingCost;
                        $iT                     =($inTotalProfit/$inTotalSourcingCost)*100;
                        $inTotalROI             = round($iT,2);
                      

                        ?>
                        <tr>
                            <td><?php echo e(date('Y-m-d', strtotime($value->order_date))); ?></td>
                            <td><?php echo e($value->order_id); ?></td>
                            <td><?php echo e($value->buyer_name); ?></td>
                            <td><?php echo e($value->item_name.' ('.$value->item_sku.')'); ?></td>
                            <td><?php echo e($soldQty); ?></td>
                            <td><?php echo e($walmartPrice); ?></td>
                         

                            <?php if($sourcingCost <= 0.40): ?>
                            <td style="color:red"><?php echo e('Missing Purcchse history'); ?></td>
                            <?php else: ?>
                            <td><?php echo e($sourcingCost); ?></td>
                            <?php endif; ?>


                            <?php if($wfsFee == null): ?>
                            <td style="color:red">
                            <span title="Please go WFS Fees & add WFS Fee">WFS Fee Missing</span>
                            </td>
                            <?php else: ?>
                            <td><?php echo e($wfsFee); ?></td>
                            <?php endif; ?>

                            <td><?php echo e($walmartFee); ?></td>
                            <td><?php echo e(number_format($profit,2)); ?></td> 
                            
                            <td><?php echo e($profitROI.'%'); ?></td>
                            <td><?php echo e($value->published_status); ?></td>
                        </tr>
                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                        <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th style="color:black;font-weight: bold;"><?php echo e($inTotalSoldQty); ?></th>
                            <th style="color:black;font-weight: bold;"><?php echo e(number_format($inTotalWalmartPrice,2)); ?></th>
                            <th style="color:black;font-weight: bold;"><?php echo e(number_format($inTotalSourcingCost,2)); ?></th>
                            <th style="color:black;font-weight: bold;"><?php echo e(number_format($inTotalWFSFee,2)); ?></th>
                            <th style="color:black;font-weight: bold;"><?php echo e(number_format($inTotalWalmartFee,2)); ?></th>
                            <th style="color:black;font-weight: bold;"><?php echo e(number_format($inTotalProfit,2)); ?></th>
                            
                            <th style="color:black;font-weight: bold;"><?php echo e($inTotalROI.'%'); ?></th>
                            <th></th>
                          
                        </tr>
                    
                    </tbody>
                    
                        
                   
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
<?php $__env->stopSection(); ?>
               
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hidatxwl/smartwfs.com/resources/views/admin/profit/index.blade.php ENDPATH**/ ?>