

<?php $__env->startSection('title'); ?>
Settings | Department 
<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-2">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item active">Roles Management</li>
        </ol>
        <div>
            <a href="<?php echo e(route('role.create')); ?>" type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2"> <i class="fa fa-plus"></i> Add New</a>
        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Roles Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Roles Name</th>
                        <th>Permissions</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php ($sl=1); ?>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key+1); ?></td>
                                <td><?php echo e($role->name); ?></td>
                                <td>
                                  <?php if($role->permissions->count() > 0): ?>
                                        <span class="badge badge-success m-1"><?php echo e($role->permissions->count()); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-success m-1">No Permission found :) </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                   <?php if(auth()->user()->hasPermission('role.edit')): ?>
                                    <a href="<?php echo e(route('role.edit', $role->id)); ?>" class="btn btn-sm btn-info float-left mr-1">
                                        <i class="fa fa-edit"></i>
                                        <span>Edit</span>
                                    </a>
                                <?php else: ?>
                                <button type="button" class="btn btn-sm btn-info float-left mr-1" disabled><i class="fa fa-edit"></i>
                                            <span>Edit</span></button>
                                      
                                <?php endif; ?>

                                    <?php if($role->deletable): ?>
                                        <?php if(auth()->user()->hasPermission('role.destroy')): ?>
                                            <form id="delete-form-<?php echo e($role->id); ?>"
                                                action="<?php echo e(route('role.destroy',$role->id)); ?>" method="POST"
                                               >
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button onclick="if (!confirm('Are you sure to delete?')) { return false }" type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash-alt"></i>
                                                <span>Delete</span>
                                            </button>
                                            </form>
                                        <?php else: ?>
                                            <button type="button" class="btn btn-sm btn-secondary " disabled><i class="fas fa-trash-alt"></i>
                                            <span>Delete</span></button>
                                        <?php endif; ?>
                                <?php else: ?>
                                        <button type="button" class="btn btn-sm btn-danger " disabled><i class="fas fa-trash-alt"></i>
                                            <span>Delete</span></button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                          <th>Sl No</th>
                          <th>Roles Name</th>
                          <th>Permissions</th>
                          <th>Action</th>
                        </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
<?php $__env->stopSection(); ?>
               
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ACLHRM\resources\views/admin/role/index.blade.php ENDPATH**/ ?>