
@extends('admin.master')
@section('title')
Dashboard | Shipments 
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Shipments Management</li>
        </ol>
      
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Shipments Report</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Image</th>
                        <th>Item Description</th>
                        
                        <th>SKU</th>
                        <th>Ship Qty</th>
                        <th>Received Qty</th>
                        <th>Damaged Units</th>
                        <th>Fill Rate %</th>
                       
                    </tr>
                    </thead>
                    <tbody>
                      @if(!empty($response))
                   @php
                       $sl = 1;
                   @endphp
                     @foreach ($response['payload'] as $item => $value)

                    
                     <tr>
                      <td>{{$sl++}}</td>
                       
                        <td>
                            @if(isset($value['imageUrl']))
                                <img src='{{$value['imageUrl']}}' height=30 width=30 ></img>
                            @else
                                <img src='' height=30 width=30 ></img>
                            @endif
                        </td>

                      <td>{{$value['itemDesc']}}</td>
                     
                      <td>{{$value['sku']}}</td>
                      <td>{{$value['itemQty']}}</td>
                      <td>{{$value['receivedQty']}}</td>
                      <td>{{$value['damagedQty']}}</td>
                      <td>{{$value['fillRate']."%"}}</td>
                      
                     
                     </tr>
                     @endforeach
                   
                      
          
    
                    @endif
                    </tbody>
                   
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               