
@extends('admin.master')
@section('title')
Dashboard | Shipments 
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Shipments Management</li>
        </ol>
      
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Shipments Report</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Inbound Order ID</th>
                        <th>Shipment ID</th>
                        <th>Create Date</th>
                        <th>Shipment Units</th>
                        <th>Received Units</th>
                         <th>Fill Rate %</th>
                        <th>Expected Date</th>
                        <th>Actual Delivery</th>
                        <th>Delivered on</th>
                        <th>Status</th>
                        <th>Tracking</th>
                        
                       
                    </tr>
                    </thead>
                    <tbody>
                      @if(!empty($response))
                   @php
                       $sl = 1;
                   @endphp
                     @foreach ($response['payload'] as $item => $value)

                    
                     <tr>
                      <td>{{$sl++}}</td>
                      <td>{{$value['inboundOrderId']}}</td>
                      
                      <td><a target="_blank" href="{{ url('shipments/items/'.$value['shipmentId']) }}">{{$sId = $value['shipmentId']}}</a></td>
                      <td>{{date('Y-m-d', strtotime($value['createdDate']))}}</td>
                      <td>{{$shipUnit = $value['shipmentUnits']}}</td>
                      <td>{{$rcvUnit = $value['receivedUnits']}}</td>
                      <?php
                        if($rcvUnit!=0){
                        $perc = ($rcvUnit/$shipUnit)*100;
                        $fillRate = number_format($perc,2)."%";
                        }
                      
                      ?>
                      @if($rcvUnit == 0)
                           <td class="text-warning"> 0.00% </td>
                      @else
                          <td><?php if($fillRate<100){echo "<span class='text-danger'>".$fillRate."</span>";}else{echo $fillRate;}?></td>
                      @endif
                      
                      
                      <td>{{date('d-M-Y', strtotime($value['expectedDeliveryDate']))}}</td>
                      
                      
                      @if(!empty($value['actualDeliveryDate']))
                
                      <td>{{$actualDate = date('d-M-Y', strtotime($value['actualDeliveryDate']))}}</td>

                      <td>{{Carbon\Carbon::createFromTimestamp(strtotime($actualDate))->diff(\Carbon\Carbon::now())->days." days ago"}}</td>
                      
                      @else
                        <td>-</td>
                        <td>-</td>
                       @endif
                       
                       
                      <td>{{$value['shipmentStatus']}}</td>
                      
        
                     @if(!empty($value['trackingNo']))
                       <td>
                           <a href="https://www.fedex.com/fedextrack/?tracknumbers={{$value['trackingNo'][0]}}" target="_blank" >Track Shipment</a>
                       </td>
                      @else
                      <td>
                          -
                      </td>
                      @endif
                      
                     </tr>
                     @endforeach
                   
                      
          
    
                    @endif
                    </tbody>
                   
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               