
@extends('admin.master')
@section('maincontent')
@section('title')
  Settings | Unit
@endsection
<div class="container-fluid">
       <ol class="breadcrumb mb-2 mt-2">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Unit Management</li>
        </ol>
        <div>
            <button type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2" data-toggle="modal" data-target="#defaultsizemodal" data-backdrop="static" data-keyboard="false"> <i class="fa fa-plus"></i> Add New</button>
        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Unit Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Unit Name</th>
                        <th class="text-center">Action</th>
                    </tr>
                    </thead>
                    <tbody>
                        @php ($sl = 1)
                            @foreach ($units as $unit)
                            <tr>
                                <td>{{$sl++}}</td>
                                <td>{{$unit->unit_name}}</td>
                                <td class="text-center">
                                    <a href="{{url('settings/unit/edit')}}/{{\Crypt::encrypt(['id'=>$unit->id])}}" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>
                                    <a href="{{url('settings/unit/delete',['id'=>$unit->id])}}" class="btn btn-sm btn-danger" onClick="return confirm('Are you sure want to delete?')"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                            @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Sl No</th>
                            <th>Unit Name</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
<div class="modal fade" id="defaultsizemodal">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Add New Unit</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
        <div class="col-md-12">
            <div class="modal-body">
                <div class="card">
                          <div class="row justify-content-center">
                              <div class="col-lg-12">
                                  <div class="card shadow-lg border-0 rounded-lg mt-5">
                                      <div class="card-body">
                                          <form action="{{url('/settings/unit/save')}}" method="POST">
                                              @csrf
                                              <div class="form-group">
                                                  <input class="form-control py-4" id="inputEmailAddress" name="unit_name" type="text" placeholder="Unit Name" />
                                                  <button onclick="this.disabled=true;this.value='Submitting...'; this.form.submit();" class="btn btn-sm btn-info mt-2 btn-block" type="submit">{{__('Save')}}</button>
                                              </div>
                                          </form>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
@endsection
               