@extends('admin.master')
@section('title')
Settings | Edit Designation
@endsection
@section('maincontent')
<div class="container-fluid">

    <ol class="breadcrumb mb-2 mt-2">
        <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
         <li class="breadcrumb-item"><a href="{{url('settings/designation/index')}}">Designations</a></li>
        <li class="breadcrumb-item active">Edit Designation</li>
    </ol>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-5">
                <div class="card shadow-lg border-0 rounded-lg mt-5">
                    <div class="card-body">
                        <form action="{{url('/settings/designation/update')}}" method="POST">
                            @csrf
                            <div class="form-group">
                                <h4><label class="small mb-0" for="inputEmailAddress">Edit Designation</label></h4><hr/>
                                <input class="form-control py-4" id="inputEmailAddress" name="designation_name" type="text" value="{{$designation->designation_name}}" placeholder="Designation Name" />
                                <input class="form-control py-4" id="inputEmailAddress" name="designation_id" type="hidden" value="{{$designation->id}}" placeholder="Designation Name" />
                                <button class="btn btn-sm btn-info mt-2 btn-block" type="submit">{{__('Update')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
