 
@extends('admin.master')
@section('title')
Reports | Salary Summary
@endsection
@section('maincontent')
<div class="container-fluid pt-2">
     <div class="row">
        
          <div class="col-lg-12">
      
            <div class="card">

              <div class="card-body">
                <div class="table-responsive" id="printableArea">
                    <style>
                        table,tr,th,td{
                            border : 1px solid black;
                            color: black;
                        }
                    </style>
                    <h5 class="text-center text-uppercase p-0 m-0">{{$unit->unit_name}}</h5>
                    <h6 class="text-center">Jamirdia, Valuka, Mymensingh.</h6>
                    <h6 class="text-center text-bold p-0 m-0"> Monthly Salary Summary </h6><br/>
                    <h6 style="text-align: center;font-size: 15px;">{{$salaryDate}}</h6>
                    
                  <table class="table">

                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Description</th>
                        <th>Total Person</th>
                        <th>Total Salary</th>
                        <th>Total Atten</th>
                        <th>Amt Per Atten</th>
                    </tr>
                    </thead>
                  @php($sl=1)
                  @foreach($employees as $employee)
                    <tbody>
                        <td>{{$sl++}}</td>
                        <td>
                        	{{$employee->designation_name}}
                        </td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                
                        </td>
                        
                      </tbody>
                  @endforeach
                  </table>
                </div>
              </div>
            
          
            </div>
            <a href="{{url('visitor/report_by')}}" class="btn btn-sm btn-dark pull-right mt-0 mt-2 "><i class="fa fa-arrow-circle-left"></i>  Back</a>
            <button onclick="printDiv('printableArea')" class="btn btn-sm btn-info pull-right mt-0 mt-2 "><i class="fa fa-print"></i>  Print</button>
        </div>
</div>

@endsection
@section('custom_js')
<script type="text/javascript">
    function printDiv(divName) {
         var printContents = document.getElementById(divName).innerHTML;
         var originalContents = document.body.innerHTML;
         document.body.innerHTML = printContents;
         window.print();
         document.body.innerHTML = originalContents;
         location.reload();
    }
    </script>
@endsection
               