
@extends('admin.master')
@section('title')

@php
if(isset($from_date)){
    echo "WFS Profit Report ".$from_date." To ".$to_date;
}else{
    echo "WFS Profit Report";
}
@endphp
@endsection
@section('maincontent')
<div class="container-fluid">
    <div class="card mb-2 mt-4 p-2">
        <section id="main-content" style="margin: auto;">
            <div class="form-row show-inputbtns" align="center">
                <form action="{{url('profit/reports')}}" method="post">
                    @csrf
                    <input name="from_date" type="date" id="from_date" /> To
                    <input name="to_date" type="date" id="to_date" />
                    <input name="submit" type="submit" value="Report" class="btn btn-sm btn-dark"/>
                </form>
                
            </div>
        </section>
    </div>
      
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> WFS orders Profit</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Date</th>
                        <th>Order#</th>
                        <th>Buyer Name</th>
                        <th>Item Name</th>
                        <th>Sold Qty</th>
                        <th>Walmart Price</th>
                        <th>Sourcing Cost</th>
                        <th>WFS Fee</th>
                        <th>Walmart Fee</th>
                        <th>Profit</th>
                        <th>ROI</th>
                        <th>Status</th>
                        
                    </tr>
                    </thead>
                    <tbody>
                        @php 
                        $inTotalSoldQty       = 0;
                        $inTotalWalmartPrice  = 0;
                        $inTotalWalmartFee    = 0;
                        $inTotalWFSFee        = 0;
                        $inTotalSourcingCost  = 0;
                        $inTotalROI           = 0;
                        $inTotalProfit        = 0;
                        $profit               = 0;
                        $sourcingCost         = 0;
                      @endphp

                        @if(!empty($response))
                        @foreach ($response as $value)
                        
                        @php

                


                        $soldQty        = $value->sold_qty;
                        $walmartPrice   = $value->walmart_price;

                        $item_qty         = $value->item_qty * $soldQty;
                        $line_total       = $value->line_total* $soldQty;
                        
                        $price_per_unit    = $line_total/$item_qty;

                        $ship_prep_cost    = $value->ship_prep_cost* $soldQty;
                        $other_cost        = $value->other_cost* $soldQty;
                        $wfs_cost          = $value->wfs_cost* $soldQty;
                        

                        $totalItemCost = ($line_total+$ship_prep_cost+$other_cost+$wfs_cost)*$soldQty;
                       
                        
                        $sourcingCost = round($totalItemCost/$item_qty,2);

                        $wfsFee         = $value->wfs_fee* $soldQty;



                        $wfc            = ($walmartPrice*0.15);
                        $walmartFee     = round($wfc,2);
                        $profit         = $walmartPrice-($walmartFee+$sourcingCost+$wfsFee);

                        if(empty($sourcingCost)){
                          $profitROI = 0;
                        }else{
                          $t =($profit/$sourcingCost)*100;
                        $profitROI      =  round($t,2);

                        }

                        //inTotal Calculate

                        $inTotalSoldQty         +=  $soldQty;
                        $inTotalWalmartPrice    +=  $walmartPrice;
                        $inTotalWalmartFee      +=  $walmartFee;
                        $inTotalProfit          +=  $profit;
                        $inTotalWFSFee          +=  $wfsFee;
                        $inTotalSourcingCost    +=  $sourcingCost;
                        $iT                     =($inTotalProfit/$inTotalSourcingCost)*100;
                        $inTotalROI             = round($iT,2);
                      

                        @endphp
                        <tr>
                            <td>{{date('Y-m-d', strtotime($value->order_date))}}</td>
                            <td>{{$value->order_id}}</td>
                            <td>{{$value->buyer_name}}</td>
                            <td>{{$value->item_name.' ('.$value->item_sku.')'}}</td>
                            <td>{{$soldQty}}</td>
                            <td>{{$walmartPrice}}</td>
                         

                            @if($sourcingCost <= 0.40)
                            <td style="color:red">{{ 'Missing Purcchse history' }}</td>
                            @else
                            <td>{{$sourcingCost}}</td>
                            @endif


                            @if($wfsFee == null)
                            <td style="color:red">
                            <span title="Please go WFS Fees & add WFS Fee">WFS Fee Missing</span>
                            </td>
                            @else
                            <td>{{$wfsFee}}</td>
                            @endif

                            <td>{{$walmartFee}}</td>
                            <td>{{number_format($profit,2)}}</td> 
                            {{-- <td>{{$profitROI.'%'}}</td> --}}
                            <td>{{$profitROI.'%'}}</td>
                            <td>{{$value->published_status}}</td>
                        </tr>
                            
                        @endforeach
                        @endif

                        <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th style="color:black;font-weight: bold;">{{$inTotalSoldQty}}</th>
                            <th style="color:black;font-weight: bold;">{{number_format($inTotalWalmartPrice,2)}}</th>
                            <th style="color:black;font-weight: bold;">{{number_format($inTotalSourcingCost,2)}}</th>
                            <th style="color:black;font-weight: bold;">{{number_format($inTotalWFSFee,2)}}</th>
                            <th style="color:black;font-weight: bold;">{{number_format($inTotalWalmartFee,2)}}</th>
                            <th style="color:black;font-weight: bold;">{{number_format($inTotalProfit,2)}}</th>
                            {{-- <th style="color:black;font-weight: bold;">{{$inTotalROI.'%'}}</th> --}}
                            <th style="color:black;font-weight: bold;">{{$inTotalROI.'%'}}</th>
                            <th></th>
                          
                        </tr>
                    
                    </tbody>
                    
                        
                   
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               