
@extends('admin.master')
@section('title')
Dashboard | Employees 
@endsection
@section('maincontent')
<div class="container-fluid">
    <ol class="breadcrumb mb-2 mt-4">
            <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item active">Employees Management</li>
        </ol>
        <div>
            <a href="{{url('employee/create')}}" type="button" class="btn btn-sm btn-info waves-effect waves-light mb-2"> <i class="fa fa-plus"></i> Add New</a>
        <div>
     
     <div class="row">
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header"><i class="fa fa-table"></i> Employees Management</div>
              <div class="card-body">
                <div class="table-responsive">
                  <table id="example" class="table table-bordered">
                    <thead>
                     <tr>
                        <th>Sl No</th>
                        <th>Name</th>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>Designation</th>
                        <th class="text-center">Photo</th>
                        <th class="text-center">Option</th>
                    </tr>
                    </thead>
                    <tbody>
                       @php($sl=1)
                       @foreach($employees as $employee) 
                            <tr>
                                <td>{{$sl++}}</td>
                                <td>{{$employee->employee_name}}</td>
                                <td>{{$employee->id_card_no}}</td>
                                <td>{{$employee->phone}}</td>
                                <td>{{$employee->designation_name}}</td>
                                <td class="text-center">

                                 <img class="img-center rounded-circle border border-black" style= 'height: 40px; width: 40px;' src="{{asset('employee/photos/'.$employee->employee_photo)}}" alt="">

                                </td>
                                <td class="text-center">
                                    <div class="dropdown show">
                <a class="btn btn-sm btn-info dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Action
                </a>
                <div class="dropdown-menu text-center" aria-labelledby="dropdownMenuLink">
                  <a href="{{url('employee/view')}}/{{\Crypt::encrypt(['id'=>$employee->id])}}" class="btn btn-sm btn-primary ml-1" title="View"><i class="fa fa-eye"></i></a>

                  <a href="{{url('employee/edit')}}/{{\Crypt::encrypt(['id'=>$employee->id])}}" class="btn btn-sm btn-secondary" title="Edit"><i class="fa fa-edit"></i></a>

                  <a href="{{url('employee/delete',['id'=>$employee->id])}}"  class="btn btn-sm  btn-danger" onClick="return confirm('Are you sure want to delete?')" title="Delete"><i class="fa fa-trash"></i></a>

                </div>
            </div>


                                </td>
                            </tr>
                        @endforeach
                           
                    </tbody>
                    <tfoot>
                        <tr>
                          <th>Sl No</th>
                          <th>Name</th>
                          <th>ID</th>
                          <th>Phone</th>
                          <th>Designation</th>
                          <th>Photo</th>
                          <th>Option</th>
                        </tr>
                    </tfoot>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
</div>
@endsection
               