@extends('admin.master')
@section('title')
Dashboard | Employees 
@endsection
@section('maincontent')
<style>
    .highlight {
      background-color: lightblue;
    }

    #calendar-body td:empty {
      cursor: text;
      border: none;
    }

    #calendar-body td {
      cursor: pointer;
    }

    #calendar thead {
      border-bottom: 2px solid #cecece;
    }

    #calendar th {
      border: none;
      text-align: center;
      padding: 0;
      width: 10%;
    }

    #calendar td {
      border: 1px solid rgba(0, 0, 0, .125);
      text-align: center;
      padding: 5px;
      width: 10%;
    }

    .previous {
      margin-top: 4%;
      margin-left: 2%;
    }

    .next {
      margin-top: 4%;
      margin-right: 2%;
    }

    .round {
      border-radius: 50%;
    }

    .month-selected {
      font-family: inherit;
      font-weight: 500;
      line-height: 1.2;
      color: inherit;
    }

    a:hover {
      text-decoration: none;
    }

    .header-row {
      background-color: lightgray;
      margin: 0px;
      padding: 0px;
    }

    #monthAndYear {
      border-bottom: none;
      background-color: transparent;
      padding-left: 14px;
      padding-right: 14px;
      display: none;
    }

    #previous,
    #next {
      color: darkslategrey;
    }

    .today-color {
      background-color: #D3D3D3;
    }

    #parent {
      border: 2px solid rgba(0, 0, 0, .125);
      border-radius: .25rem;
      padding: 5px;
    }

    .date-values {
      width: 297px;
      padding: 5px;
      border-radius: 5px;
      border: 1px solid #cecece;
    }


    .buttonPanel td {
      border: none !important;
      padding: 6px 0 0 0 !important;
    }

    .buttonPanel td div:nth-of-type(odd) {
      padding: 5px;
      /*border: 1px solid #cecece;*/
      width: 100%;
      text-align: left;
    }

    .buttonPanel td div:nth-of-type(even) {
      padding: 5px;
      /*border: 1px solid #cecece;*/
      width: 100%;
      text-align: right;
    }

    .buttonPanel-row {
      margin: 0;
      border-top: 2px solid lightgray;
    }

    .form-control {
      color: #000;
      border: 1px solid;
    }

    .control-label {
      color: #000;
      font-weight: bold;
    }

    .dueFree {
      color: #000;
      font-weight: bold;
      padding: 2px 0px;
    }

    .due {
      color: #F00;
      font-weight: bold;
      padding: 2px 0px;
    }
</style>
<script>
	function editFun() {   
	  
    document.getElementById('bonusId').disabled = false;
    document.getElementById('bonusRId').disabled = false;
    document.getElementById('nightId').disabled = false;
    document.getElementById('nightRId').disabled = false; 
    document.getElementById('nightTotalId').disabled = false;
    document.getElementById('nightTotalRId').disabled = false;
	document.getElementById('updBtn').disabled = false;
	

}
function validate(evt) {
  var theEvent = evt || window.event;

  // Handle paste
  if (theEvent.type === 'paste') {
      key = event.clipboardData.getData('text/plain');
  } else {
  // Handle key press
      var key = theEvent.keyCode || theEvent.which;
      key = String.fromCharCode(key);
  }
  var regex = /[0-9]|\./;
  if( !regex.test(key) ) {
    theEvent.returnValue = false;
    if(theEvent.preventDefault) theEvent.preventDefault();
  }
}

</script>
<div class="container-fluid">
        <div class="row d-flex justify-content-center">
        	<div class="col-sm-4 col-sm-offset-4">
        		<form action="{{url('absent/create')}}" method="POST">
					@csrf
        			<table> 
        			<tr>
        				<td><input type="text" class="input-control" name="employeeId" id="refd" placeholder="Search Employee ID"></td>
        				<td><input type="submit" class="btn btn-info" value="Search"></td>
        			</tr>
        		</table>
        		</form>
            </div>
        </div> 
        <hr/>
		
		@if (!empty($employees))
                <div class="row">
                	<div class="col-sm-4">
                        <div class="panel panel-default">
                        <div class="panel-heading" style="background-color: #09A9A1">
                          <div class="pull-left" style="color:#000; font-weight:bold">Employee Information</div>
                        </div>
                        <div class="panel-body">
                          <div class="padd">
                              <div class="form">
                                <table border="0" width="100%" style="color:#000">
									@foreach ($employees as $employee)
										
									@endforeach
									
                                <tr>
                                	<td width="100px" style="padding:2px 3px; border-bottom:1px solid #999">Employee ID</td>
                                    <td width="5px" style="border-bottom:1px solid #999">:</td>
                                    <td style="padding:2px 5px; border-bottom:1px solid #999">{{$employee->id_card_no}}</td>
                                </tr>
                                <tr>
                                	<td width="100px" style="padding:2px 3px; border-bottom:1px solid #999">Name</td>
                                    <td width="5px" style="border-bottom:1px solid #999">:</td>
                                    <td style="padding:2px 5px; border-bottom:1px solid #999">{{$employee->employee_name}}</td>
                                </tr>
                              
                                <tr>
                                	<td width="100px" style="padding:2px 3px; border-bottom:1px solid #999">Designation</td>
                                    <td width="5px" style="border-bottom:1px solid #999">:</td>
                                    <td style="padding:2px 5px; border-bottom:1px solid #999">{{$employee->designation_name}}</td>
                                </tr>
                                </table>
                              </div>
                         </div>
                        </div>
                        </div>
                     
                    <form action="{{url('absent/save')}}" method="POST" >
                              @csrf
                        
                         <input type="hidden" name="employee_id" value="{{$employee->id_card_no}}">
                 </div>
                <div class="col-sm-8">
                        <div class="panel panel-default">
                        <div class="panel-heading bg-info">
                          <div class="pull-left" style="color:#000; font-weight:bold">Absent Count</div>
                        </div>
                        <div class="panel-body">
                          <div class="padd">
                              <div class="form" style="min-height:100px;">
								<div class="form" style="min-height:100px;">
                                    <form action="" method="post">
                                      <div class="table-responsive">
                                        <div style="margin:10px;">
                                          <div style="width: 100%;border: 1px solid #999">
                                            <input type="text" style="width: 70%;" name="dates" value="" id="selectedValues" class="date-values" readonly />
                                            <input type="text" name="abs_total_days" id="ST" class="date-values" value="" style="border: none; width: 25%" readonly />
                                          </div>

                                          <div id="parent">
                                            <table class="table table-bordered">
                                              <tr>
                                                <td>
                                                  <div class="previous form-control" style="border: none;text-align: center;">
                                                    <a href="#" id="previous" onclick="previous()">
                                                      <i class="fa fa-arrow-left" aria-hidden="true"></i>
                                                    </a>
                                                  </div>
                                                </td>
              
                                                <td>
                                                  <div id="monthAndYear">
                                                  </div>
                                                  <div class="col-sm form-control" style="border: none;text-align: center;">
                                                    <select name="salary_month" id="month" class="input-control" onchange="change()"></select>
                                                  </div>
                                                </td>
                                                <td>
                                                  <div class="col-sm form-control" style="border: none;text-align: center;">
                                                    <select name="salary_year" id="year" class="input-control" onchange="change()"></select>
                                                  </div>
              
                                                </td>
                                                <td>
                                                  <div class="form-control" style="border: none;text-align: center;">
                                                    <a href="#" id="next" onclick="next()">
                                                      <i class="fa fa-arrow-right" aria-hidden="true"></i>
                                                    </a>
                                                  </div>
              
                                                </td>
                                              </tr>
                                            </table>
                                            <table id="calendar" class="table">
                                              <thead>
                                                <tr class="bg-primary" style="color:white;">
                                                  <th style="color:white;">S</th>
                                                  <th style="color:white;">M</th>
                                                  <th style="color:white;">T</th>
                                                  <th style="color:white;">W</th>
                                                  <th style="color:white;">T</th>
                                                  <th style="color:white;">F</th>
                                                  <th style="color:white;">S</th>
                                                </tr>
                                              </thead>
                                              <tbody id="calendarBody"></tbody>
                                            </table>
                                            <div class="col text-center">
                                              <button class="btn btn-info" type="submit" id="updBtn">Update</button>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                  </div>
                                </div>
                                </form>
                              </div>
                              </div>
                         </div>
                        </div>
                        </div>
                
               
		@endif
</div>
@endsection