<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProfitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('profits', function (Blueprint $table) {
            $table->id();
            $table->string('user_id',255)->nullable();
            $table->string('order_date',255)->nullable();
            $table->string('order_id',255)->nullable();
            $table->string('buyer_name',255)->nullable();
            $table->string('item_name',255)->nullable();
            $table->string('item_sku',255)->nullable();
            $table->text('item_image_url')->nullable();
            $table->string('sold_qty',255)->nullable();
            $table->string('walmart_price',255)->nullable();
            $table->string('wfs_fee',255)->nullable();
            $table->string('published_status',255)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('profits');
    }
}
