<?php

namespace App\Imports;
use App\Models\CurrentItemPrice;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithStartRow;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class ImportPrice implements ToModel,WithHeadingRow,WithStartRow
{
    /**
    * @param Collection $collection
    */
     public function model(array $row)
    {
        return new Price([
            'item_id' => $row['item_id'],
            'item_upc' => $row['item_upc'],
            'price' => $row['price']
            
        ]);
    }

    public function headingRow(): int
    {
        return 1;
    }
    
    /**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }
}
