<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Gate;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::all();
        return view('admin.users.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::all(); 
        return view('admin.users.form', compact('roles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255',
            'email' => 'required|unique:users|max:255',
            'role_id' => 'required|integer',
            'password' => 'min:4',
            'password_confirmation' => 'required_with:password|same:password|min:4',
            'store_name' => 'required',
            'client_id' => 'required',
            'client_secret' => 'required',
        ]);

        $user =User::create([
            'name' => $request->name,
            'email' => $request->email,
            'role_id' => $request->role_id,
            'status' => $request->status,
            'password' => Hash::make($request->password),
            'store_name' => $request->store_name,
            'client_id' => $request->client_id,
            'client_secret' => $request->client_secret,

        ]);

         return redirect()->route('user.index')
         ->with('success','User Create Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        $roles = Role::all();
        return view('admin.users.form', compact('user','roles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        $request->validate([
            'name' => 'required|max:255',
            'email' => 'required|max:255|email|unique:users,email,'.$user->id,
            'role_id' => 'required|integer',
            'password' => 'nullable|confirmed|min:8',
            'store_name' => 'required',
            'client_id' => 'required',
            'client_secret' => 'required',
 
        ]);

        $user->update([
            'name' => $request->name,
            'email' => $request->email,
            'role_id' => $request->role_id,
            'status' => $request->filled('status'),
            'store_name' => $request->store_name,
            'client_id' => $request->client_id,
            'client_secret' => $request->client_secret,
            'password' => isset($request->password) ? Hash::make($request->password):$user->password
        ]);
        
        return redirect()->route('user.index')
        ->with('success','User Update Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
         if($user){
            $user->delete();
            return redirect()->back()->with('error','User Delete Successfully');
        }else{
           return redirect()->back()->with('error','Delete Failed');
        }
        
        return redirect()->back()->with('error','Delete Failed');
    }
}
