<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use App\Models\ShippedItems;


class ShipmentController extends Controller
{

    public function shipmentReport(Request $request){

        $id = $request->user()->id;
        $users = User::where('id',$id)->get();
        foreach($users as $user){

        }

        global $c_id;
        global $c_secret;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
      

        return $this->Report();

    }
    
     public function shipmentItems(Request $request,$shipmentId){
         
        
        $id = $request->user()->id;
        $users = User::where('id',$id)->get();
        foreach($users as $user){

        }

        global $c_id;
       
      
        global $c_secret;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
        
        return $this->Items($shipmentId);
        
    }
    
    
      public function openCase(Request $request,$shipmentId){
         
        
        $id = $request->user()->id;
        $users = User::where('id',$id)->get();
        foreach($users as $user){

        }

        global $c_id;
       
      
        global $c_secret;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
        
        return $this->caseopen($shipmentId);
        
    }
    
    


    function getWalmartDetail()
	{
        global $c_id;
        global $c_secret;
		$data = [];	
		$data['client_id'] = $c_id;
		$data['client_secret'] = $c_secret;
		return $data;
	}

    function getToken()
	{
		$data = $this->getWalmartDetail();
		$client_id = $data['client_id'];
		$client_secret = $data['client_secret'];
		$url = "https://marketplace.walmartapis.com/v3/token";
		$uniqid = uniqid();
		$authorization_key = base64_encode($client_id.":".$client_secret);
		$code = "";

		$ch = curl_init();
		$options = array(

				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_TIMEOUT => 60,
				CURLOPT_HEADER => false,
				CURLOPT_POST =>1,
				CURLOPT_POSTFIELDS => "grant_type=client_credentials",
				CURLOPT_HTTPHEADER => array(

						"WM_SVC.NAME: Walmart Marketplace",
						"WM_QOS.CORRELATION_ID: $uniqid",
						"Authorization: Basic $authorization_key",
						"Accept: application/json",
						"Content-Type: application/x-www-form-urlencoded",
				),
		);
		curl_setopt_array($ch,$options);
		$response = curl_exec($ch);
		$code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
		curl_close($ch);

		if($code == 201 || $code == 200)
		{
			$token = json_decode($response,true);
			return $token['access_token'];
		} 
	}

    public function Report(){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
         $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
      
         $url="https://marketplace.walmartapis.com/v3/fulfillment/inbound-shipments?limit=999";
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
              
               $ShippedItems = ShippedItems::all();

              return view('admin.shipment.index', compact('response'))
              ->with('ShippedItems',$ShippedItems);;
              
        } else {
            return view('admin.shipment.index')->with('error','Data not found!');
        }
    }
    
    
    
    public function Items($shipmentId){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
        $url="https://marketplace.walmartapis.com/v3/fulfillment/inbound-shipment-items?shipmentId=$shipmentId&limit=50";
      
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
              
              $storeName = Auth::user()->name;
              $userId = Auth::user()->id;
              
              
             foreach($response['payload'] as $item => $value){
                $inboundOrderId             = $value['inboundOrderId'];
                $shipmentId                 = $value['shipmentId'];
                $gtin                       = $value['gtin'];
                $sku                        = $value['sku'];
                $itemDesc                   = $value['itemDesc'];
                $itemQty                    = $value['itemQty'];
                $receivedQty                = $value['receivedQty'];
                $expectedDeliveryDate       = $value['expectedDeliveryDate'];
                

                ShippedItems::updateOrCreate(
                    [
                        'sku'  => $sku,
                        'expectedDeliveryDate'  => $expectedDeliveryDate,
                    ],
                
                    [
                      'storeName'              => $storeName,
                      'user_id'                => $userId,
                      'inboundOrderId'         => $inboundOrderId,
                      'shipmentId'             => $shipmentId,
                      'gtin'                   => $gtin,
                      'sku'                    => $sku,
                      'itemDesc'               => $itemDesc,
                      'itemQty'                => $itemQty,
                      'receivedQty'            => $receivedQty,
                      'expectedDeliveryDate'   => $expectedDeliveryDate,
                     
                    ]);

                
    
              } 
              
            return view('admin.shipment.items', compact('response'));
              
        } else {
            
            return view('admin.shipment.index')->with('error','Data not found!');
        }
    }
    
    

    
    
      public function caseopen($shipmentId){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
        $url1="https://marketplace.walmartapis.com/v3/fulfillment/inbound-shipments?shipmentId=$shipmentId&limit=999";
        
        
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url1,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response1 = json_decode($response,true);
              
               foreach ($response1['payload'] as $item => $value1){
                  
                  
              }
              
        }
              
        
        
        
        
        
        
        $url="https://marketplace.walmartapis.com/v3/fulfillment/inbound-shipment-items?shipmentId=$shipmentId&limit=50";
      
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
              
              
              $dataAnalize = array_merge($response,$value1);
    
    
              
              return view('admin.shipment.case', compact('dataAnalize'));
              
        } else {
            
            return view('admin.shipment.index')->with('error','Data not found!');
        }
    }
    
    
    
    public function shipItems(){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
        $url="https://marketplace.walmartapis.com/v3/fulfillment/inbound-shipments?shipmentId=1796328GDM";
      
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
             
            return $response;
             
              
        } else {
            return 0;
            
        }
    }
    
    
     public function shippedUploads($shipmentId){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
        $url="https://marketplace.walmartapis.com/v3/fulfillment/inbound-shipment-items?shipmentId=$shipmentId&limit=999";
      
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
              
             
             return view('admin.shipment.items', compact('response'));
              
        } else {
            
            return view('admin.shipment.index')->with('error','Data not found!');
        }
    }
    
    
   


    

	



}
 