<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Purchase;
use App\Models\CurrentItemPrice;
use App\Models\User;
use Validator;
use DB;

class PurchaseController extends Controller
{

    public function addPurchase(Request $request){


        $id = $request->user()->id;
        $users = User::where('id',$id)->get();
        foreach($users as $user){

        }

        global $user_id;
        global $c_id;
        global $c_secret;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
        $user_id = $user->id;
      

        $this->Report();
        return view('admin.purchase.add');
    }



    function getWalmartDetail()
	{
        global $c_id;
        global $c_secret;
		$data = [];	
		$data['client_id'] = $c_id;
		$data['client_secret'] = $c_secret;
		return $data;
	}

    function getToken()
	{
		$data = $this->getWalmartDetail();
		$client_id = $data['client_id'];
		$client_secret = $data['client_secret'];
		$url = "https://marketplace.walmartapis.com/v3/token";
		$uniqid = uniqid();
		$authorization_key = base64_encode($client_id.":".$client_secret);
		$code = "";

		$ch = curl_init();
		$options = array(

				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_TIMEOUT => 60,
				CURLOPT_HEADER => false,
				CURLOPT_POST =>1,
				CURLOPT_POSTFIELDS => "grant_type=client_credentials",
				CURLOPT_HTTPHEADER => array(

						"WM_SVC.NAME: Walmart Marketplace",
						"WM_QOS.CORRELATION_ID: $uniqid",
						"Authorization: Basic $authorization_key",
						"Accept: application/json",
						"Content-Type: application/x-www-form-urlencoded",
				),
		);
		curl_setopt_array($ch,$options);
		$response = curl_exec($ch);
		$code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
		curl_close($ch);

		if($code == 201 || $code == 200)
		{
			$token = json_decode($response,true);
			return $token['access_token'];
		} 
	}

    public function Report(){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
         $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
      
        $url =  "https://marketplace.walmartapis.com/v3/items?limit=200&publishedStatus=PUBLISHED";
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
              
              return $response;
            //   return view('admin.product.index', compact('response'));
              
            global $user_id;
              foreach($response['ItemResponse'] as $item => $value){
                  
                 
                
                $sku                = $value['sku'];
                 
                // $upc                = $value['upc'];
                $gtin               = $value['gtin'];
                $product_name       = $value['productName'];
                $product_type       = $value['productType'];
                $current_price      = $value['price']['amount'];
                $published_status   = $value['publishedStatus'];
                
                if(Product::where('gtin', $gtin)->exists()) {
                  }else{
                    DB::table('products')
                    ->insert([
                    'user_id'               => $user_id,
                    'sku'                   => $sku,
                    // 'upc'                   => $upc,
                    'gtin'                  => $gtin,
                    'product_name'          => $product_name,
                    'product_type'          => $product_type,
                    'current_price'         => $current_price,
                    'published_status'      => $published_status
                   
                    ]);


                  }

               

              }
            //    return redirect('dashboard')->with('success','Sync Successfully!!');  

               
        } else {
            return redirect('dashboard')->with('error','Data not found!!'); 
        }

        
    }















    public function getAutocompleteData(){

       return Product::all();

        // if($request->has('term')){
        //     return Product::where('product_name','like','%'.$request->input('term').'%')->get();
        // }
    }

    public function insert(Request $request){

        if($request->ajax())
        { 
         $rules = array(
          'item_sku.*'  => 'required',
          'suplier_name.*'  => 'required',
          'po_date.*'  => 'required',
          'item_qty.*'  => 'required',
          'price_per_unit.*'  => 'required',
          'ship_prep_cost.*'  => 'required',
          'other_cost.*'  => 'required',
          'wfs_cost.*'  => 'required',
         );
         $error = Validator::make($request->all(), $rules);
         if($error->fails())
         {
          return response()->json([
           'error'  => $error->errors()->all()
          ]);
         }
   
         $user_id = $request->user_id;
         $item_sku = $request->item_sku;
         $suplier_name = $request->suplier_name;
         $po_date = $request->po_date;
         $item_qty = $request->item_qty;
         $line_total = $request->line_total;
         $ship_prep_cost = $request->ship_prep_cost;
         $other_cost = $request->other_cost;
         $wfs_cost = $request->wfs_cost;
        
         for($count = 0; $count < count($item_sku); $count++)
         {
          $data = array(
           'user_id' => $user_id[$count],
           'item_sku' => $item_sku[$count],
           'suplier_name'  => $suplier_name[$count],
           'po_date'  => $po_date[$count],
           'item_qty'  => $item_qty[$count],
           'line_total'  => $line_total[$count],
         
           'ship_prep_cost'  => $ship_prep_cost[$count],
           'other_cost'  => $other_cost[$count],
           'wfs_cost'  => $wfs_cost[$count]
       
         
           
          );
          $insert_data[] = $data; 
        //   Purchase::updateOrCreate($data);


        $stock = Purchase::where([
            ['item_sku', '=', $data['item_sku']]
        ])->first();
    
        if ($stock) {
       
            if($stock->item_qty == 1){
                $qty = $data['item_qty'] - 1;
                $stock->increment('item_qty', $qty);
            }else{
                $stock->increment('item_qty', $data['item_qty']);
            }

            if($stock->line_total == 0.01){
                $lTotal = $data['line_total'] - 0.01;
                $stock->increment('line_total', $lTotal);

            }else{
                $stock->increment('line_total', $data['line_total']);
            }
           
            return response()->json([
                'success'  => 'Purchase updated'
               ]);
      


        } else {
            Purchase::insert($insert_data);
            return response()->json([
                'success'  => 'Purchase Added'
               ]);
        }



         

         }
   
      

         
        }
       

       }




       public function reportPurchase(Request $request){
        $user_id = $request->user()->id;


         $response = Purchase::where('user_id', $user_id)->get();
         
         
        
        //  $response = Purchase::where('purchases.user_id', $user_id)
        // ->leftJoin('current_item_prices', 'current_item_prices.item_upc', '=', 'purchases.p_upc')
        // ->get();
        
        //   $response = Purchase::where('purchases.user_id', $user_id)
        //         ->leftJoin('current_item_prices', function($join) {
        //             $join->on(DB::raw('LPAD(current_item_prices.item_upc, 14, "0")'), '=', DB::raw('LPAD(purchases.p_upc, 14, "0")'));
        //         })
        //         ->get();
                
    
        return view('admin.purchase.report')
        ->with('response', $response);
       }


       public function update(Request $request)
       {
          if($request->ajax())
          {
              $Id = $request->Id;
              $fieldName = $request->fieldName;
              $values = $request->values;
              $result = DB::table('purchases')
                 ->where('id', $Id)
                 ->update([
                     $fieldName => $values]);
          }
   

          
           
       }
       
       public function updateWfsFee(Request $request)
            {
                $user_id = $request->user()->id;
                $sku = $request->input('sku');
                $uwfsFee = $request->input('uwfsFee');
        
                // Find the purchase by SKU and user_id and update the WFS fee
                $purchase = Purchase::where('item_sku', $sku)
                                    ->where('user_id', $user_id)
                                    ->first();
        
                if ($purchase) {
                    $purchase->wfs_fee = $uwfsFee;
                    $purchase->save();
                    return response()->json(['success' => true]);
                } else {
                    return response()->json(['success' => false, 'message' => 'Item not found'], 404);
                }
            }
    
       
       
       
   
    
}
