<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Product;
use App\Models\Profit;
use App\Models\Purchase;
use App\Models\ImportExcel;
use DB;

class ProfitController extends Controller
{
    // public function indexProfit(Request $request){

    //     $id = $request->user()->id;
    //     $users = User::where('id',$id)->get();
    //     foreach($users as $user){

    //     }

    //     global $user_id;
    //     global $c_id;
    //     global $c_secret;
    //     $c_id = $user->client_id;
    //     $c_secret = $user->client_secret;
    //     $user_id = $user->id;
      

    //     return $this->Report();

    // }

    public function proReport(){
        return view('admin.profit.index');
    }

    public function reportProfit(Request $request){
       
        $id = $request->user()->id;
        $users = User::where('id',$id)->get();
        foreach($users as $user){

        }

        global $user_id;
        global $c_id;
        global $c_secret;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
        $user_id = $user->id;
      

        $this->Report();

        return view('admin.profit.index');
    }


    function getWalmartDetail()
	{
        global $c_id;
        global $c_secret;
		$data = [];	
		$data['client_id'] = $c_id;
		$data['client_secret'] = $c_secret;
		return $data;
	}

    function getToken()
	{
		$data = $this->getWalmartDetail();
		$client_id = $data['client_id'];
		$client_secret = $data['client_secret'];
		$url = "https://marketplace.walmartapis.com/v3/token";
		$uniqid = uniqid();
		$authorization_key = base64_encode($client_id.":".$client_secret);
		$code = "";

		$ch = curl_init();
		$options = array(

				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_TIMEOUT => 60,
				CURLOPT_HEADER => false,
				CURLOPT_POST =>1,
				CURLOPT_POSTFIELDS => "grant_type=client_credentials",
				CURLOPT_HTTPHEADER => array(
 
						"WM_SVC.NAME: Walmart Marketplace",
						"WM_QOS.CORRELATION_ID: $uniqid",
						"Authorization: Basic $authorization_key",
						"Accept: application/json",
						"Content-Type: application/x-www-form-urlencoded",
				),
		);
		curl_setopt_array($ch,$options);
		$response = curl_exec($ch);
		$code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
		curl_close($ch);

		if($code == 201 || $code == 200)
		{
			$token = json_decode($response,true);
			return $token['access_token'];
		} 
	}

    public function Report(){

       
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $authorization = base64_encode($client_id . ":" . $client_secret);
      
        $url="https://marketplace.walmartapis.com/v3/orders?shipNodeType=WFSFulfilled&createdStartDate=2021-01-01&limit=200&productInfo=true";
    
        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
              
            //   return view('admin.product.index', compact('response'));


            global $user_id;
            foreach ($response['list']['elements'] as $item => $value){

              for($i = 0; $i < count($value); $i++) {
              
               $orderDateTime   = $value[$i]['orderDate'];
               $shipDateTime    = $value[$i]['shippingInfo']['estimatedShipDate'];
               $orderDate2       =  date('Y-m-d',$orderDateTime/1000);
               $t = $orderDateTime/1000;
               $orderDate = date("Y-m-d H:i:s",$t);
               $shipDate        =  date('Y-m-d',$shipDateTime/1000);


                $order_id           =  $value[$i]['customerOrderId'];
                $buyer_name         =  $value[$i]['shippingInfo']['postalAddress']['name'];
                $item_name          =  $value[$i]['orderLines']['orderLine'][0]['item']['productName'];
                $item_image_url     =  $value[$i]['orderLines']['orderLine'][0]['item']['imageUrl'];
                $item_sku           =  $value[$i]['orderLines']['orderLine'][0]['item']['sku'];

               
                // $sold_qty       =  $value[$i]['orderLines']['orderLine'][0]['lineNumber'];
                // $sold_qty       =  $value[$i]['orderLines']['orderLine'][1]['lineNumber'];

                 $sold_qty = 0;

                            if (isset($value[$i]['orderLines']['orderLine'])) {
                           
                                foreach ($value[$i]['orderLines']['orderLine'] as $orderLine) {
                                    if (isset($orderLine['orderLineQuantity']['amount'])) {
                                        $sold_qty += intval($orderLine['orderLineQuantity']['amount']);
                                    }
                                }
                            }
                

                $walmart_price  =  $value[$i]['orderLines']['orderLine'][0]['charges']['charge'][0]['chargeAmount']['amount'];
                $status         =  $value[$i]['orderLines']['orderLine'][0]['orderLineStatuses']['orderLineStatus'][0]['status'];

                
                // if(Profit::where('order_id', $order_id)->exists()) {
                //           }else{
                //             DB::table('profits')
                //             ->insert([
                //             'user_id'               => $user_id,
                //             'order_date'            => $orderDate,
                //             'order_id'              => $order_id,
                //             'buyer_name'            => $buyer_name,
                //             'item_name'             => $item_name,
                //             'item_sku'              => $item_sku,
                //             'sold_qty'              => $sold_qty,
                //             'walmart_price'         => $walmart_price,
                //             'published_status'      => $status
                           
                //             ]);
        
        
                //           }

                Profit::updateOrCreate(
                        [
                            'order_id'  => $order_id,
                            'user_id'   => $user_id,

                        ],
                    
                        [
                          'user_id'               => $user_id,
                          'order_date'            => $orderDate,
                          'order_id'              => $order_id,
                          'buyer_name'            => $buyer_name,
                          'item_name'             => $item_name,
                          'item_sku'              => $item_sku,
                          'item_image_url'        => $item_image_url,
                          'sold_qty'              => $sold_qty,
                          'walmart_price'         => $walmart_price,
                          'published_status'      => $status,
                         
                        ]);
      
      
                    
                if(ImportExcel::where('order_id', $order_id)->exists()) {
                        }else{
                          
                          DB::table('import_excels')
                          ->insert([ 
                          'user_id'               => $user_id,
                          'order_id'              => $order_id,
                          'item_name'             => $item_name,
                          'wfs_fee'               => 0,
                          ]);
      
      
                        }


                if(Purchase::where('item_sku', $item_sku)->exists()) {
                        }else{
                          
                          DB::table('purchases')
                          ->insert([ 
                          'user_id'               => $user_id,
                          'item_sku'              => $item_sku,
                          'item_qty'              => 1,
                          'line_total'              => 0.01,
                          ]);
      
      
                        }


            }
            
        }
              
        } else {
            return redirect('admin.profit.index')->with('error','Data not found!!'); 
        }

        
    }

   

    public function reportsProfit(Request $request){
       
        $user_id = $request->user()->id;
        $to_date = $request->to_date;
        $from_date = $request->from_date;

        $response = DB::table('profits')
        ->join('purchases','purchases.item_sku','=','profits.item_sku') 
        ->leftjoin('import_excels','import_excels.order_id','=','profits.order_id') 
        ->where('profits.user_id', $user_id)
        ->where('purchases.user_id', $user_id)
        ->whereBetween('order_date', [$from_date, $to_date])
        ->orderBy('order_date','DESC')
        ->get();
 

        // dd($response);
        // ->leftjoin('salaries','salaries.employee_id','=','employees.id_card_no') 
        // ->leftjoin('nights','nights.employees_id','=','salaries.employee_id')
       
        // $response =  Profit::where('user_id', $user_id)->whereBetween('order_date', [$from_date, $to_date])->orderBy('order_date','DESC')->get();

        return view('admin.profit.index', compact('response'))
        ->with('from_date',$from_date)
        ->with('to_date',$to_date);


    }
    
    public function syncOrders(){
         return view('admin.profit.sync');
    }
    
    
    public function ordersSync(Request $request) {
        $createdStartDate = $request->query('createdStartDate');
        $createdEndDate = $request->query('createdEndDate');
        
        
        $id = $request->user()->id;
        $users = User::where('id',$id)->get();
        foreach($users as $user){

        }

        global $user_id;
        global $c_id;
        global $c_secret;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
        $user_id = $user->id;
        
        $token = $this->getToken();
        
        $authorization = base64_encode($c_id . ":" . $c_secret);
        
        $url = "https://marketplace.walmartapis.com/v3/orders?shipNodeType=WFSFulfilled&createdStartDate=$createdStartDate&createdEndDate=$createdEndDate&limit=200&productInfo=true";

        $ch      = curl_init();
        $qos     = uniqid();
        $options = array(
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 60,
            CURLOPT_HEADER         => false,
            CURLOPT_HTTPHEADER     => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $qos",
                "Authorization: Basic $authorization",
                "WM_SEC.ACCESS_TOKEN:$token",
                "Accept: application/json",
                "Content-Type: application/json",
            ),
            CURLOPT_HTTPGET        => true,
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        if ($code == 201 || $code == 200) {
              $response = json_decode($response,true);
              
        
            global $user_id;
            foreach ($response['list']['elements'] as $item => $value){

              for($i = 0; $i < count($value); $i++) {
              
               $orderDateTime   = $value[$i]['orderDate'];
               $shipDateTime    = $value[$i]['shippingInfo']['estimatedShipDate'];
               $orderDate2       =  date('Y-m-d',$orderDateTime/1000);
               $t = $orderDateTime/1000;
               $orderDate = date("Y-m-d H:i:s",$t);
               $shipDate        =  date('Y-m-d',$shipDateTime/1000);


                $order_id           =  $value[$i]['customerOrderId'];
                $buyer_name         =  $value[$i]['shippingInfo']['postalAddress']['name'];
                $item_name          =  $value[$i]['orderLines']['orderLine'][0]['item']['productName'];
                $item_image_url     =  $value[$i]['orderLines']['orderLine'][0]['item']['imageUrl'];
                $item_sku           =  $value[$i]['orderLines']['orderLine'][0]['item']['sku'];


                 $sold_qty = 0;

                            if (isset($value[$i]['orderLines']['orderLine'])) {
                           
                                foreach ($value[$i]['orderLines']['orderLine'] as $orderLine) {
                                    if (isset($orderLine['orderLineQuantity']['amount'])) {
                                        $sold_qty += intval($orderLine['orderLineQuantity']['amount']);
                                    }
                                }
                            }
                

                $walmart_price  =  $value[$i]['orderLines']['orderLine'][0]['charges']['charge'][0]['chargeAmount']['amount'];
                $status         =  $value[$i]['orderLines']['orderLine'][0]['orderLineStatuses']['orderLineStatus'][0]['status'];

                
                Profit::updateOrCreate(
                        [
                            'order_id'  => $order_id,
                            'user_id'   => $user_id,

                        ],
                    
                        [
                          'user_id'               => $user_id,
                          'order_date'            => $orderDate,
                          'order_id'              => $order_id,
                          'buyer_name'            => $buyer_name,
                          'item_name'             => $item_name,
                          'item_sku'              => $item_sku,
                          'item_image_url'        => $item_image_url,
                          'sold_qty'              => $sold_qty,
                          'walmart_price'         => $walmart_price,
                          'published_status'      => $status,
                         
                        ]);
      
      
                    
                if(ImportExcel::where('order_id', $order_id)->exists()) {
                        }else{
                          
                          DB::table('import_excels')
                          ->insert([ 
                          'user_id'               => $user_id,
                          'order_id'              => $order_id,
                          'item_name'             => $item_name,
                          'wfs_fee'               => 0,
                          ]);
      
      
                        }


                if(Purchase::where('item_sku', $item_sku)->exists()) {
                        }else{
                          
                          DB::table('purchases')
                          ->insert([ 
                          'user_id'               => $user_id,
                          'item_sku'              => $item_sku,
                          'item_qty'              => 1,
                          'line_total'              => 0.01,
                          ]);
      
      
                        }


            }
            
        }
              
        } else {
            return "Data Not found"; 
        }
        
        
        
        
    
    
    }

    
    
}
