<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\ItemsReport;
use App\Models\blacklist;
use App\Models\Inventory;
use Carbon\Carbon;
use DB;

class ItemsReportController extends Controller
{
    public function manageBuybox(Request $request)
    {
        $id = $request->user()->id;
        
        

    $subquery = \DB::table('import_excels as ie')
        ->select('ie.item_name', \DB::raw('MAX(ie.updated_at) as latest_updated_at'))
        ->where('ie.user_id', $id)
        ->groupBy('ie.item_name');

    $response = ItemsReport::select(
        'items_reports.id as items_report_id',
        'items_reports.user_id',
        'items_reports.store_name',
        'items_reports.item_image',
        'items_reports.item_name',
        'items_reports.item_sku',
        'items_reports.item_price',
        'items_reports.item_inventory',
        'items_reports.item_buybox_price',
        'items_reports.item_id',
        'items_reports.item_upc',
        'items_reports.updated_at',
        'purchases.id as purchase_id',
        'purchases.user_id as purchase_user_id',
        'purchases.item_sku as purchase_item_sku',
        'purchases.suplier_name',
        'purchases.po_date',
        'purchases.item_qty',
        'purchases.line_total',
        'purchases.ship_prep_cost',
        'purchases.other_cost',
        'purchases.wfs_cost',
        'purchases.wfs_fee',
        'ie.wfs_fee as i_wfs_fee'
    )
    ->leftJoin('purchases', 'purchases.item_sku', '=', 'items_reports.item_sku')
    ->leftJoin('import_excels as ie', function($join) use ($subquery, $id) {
        $join->on('ie.item_name', '=', 'items_reports.item_name')
             ->where('ie.user_id', $id)
             ->joinSub($subquery, 'sq', function($join) {
                 $join->on('ie.item_name', '=', 'sq.item_name')
                      ->on('ie.updated_at', '=', 'sq.latest_updated_at');
             });
    })
    ->where('items_reports.user_id', $id)
    
    ->where('items_reports.item_inventory', '>=', 1)
    ->get();


    
    return view('admin.buybox.index', compact('response'));
        
    }
    
    
       public function updatePrice(Request $request)
    {
        if ($request->ajax()) {
            $Id = $request->Id;
            $Sku = $request->ItemSku;
            $fieldName = $request->fieldName;
            $price = $request->values;
        
            $desiredTimeZone = 'Asia/Dhaka';
            $currentTime = Carbon::now($desiredTimeZone);
    
            $result = DB::table('items_reports')
                ->where('id', $Id)
                ->update([
                    $fieldName => $price,
                    "updated_at" => $currentTime,
                ]);
                
          
        }
        if ($result) {
        $id = $request->user()->id;
        $users = User::where('id', $id)->get();
        foreach ($users as $user) {

        }

        global $c_id;
        global $c_secret;
        global $user_id;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
        $user_id = $user->id;

        return $this->updateItemPrice($Sku,$price);
            
        }
        
    }
    
    
    public function getWalmartDetail()
    {
        global $c_id;
        global $c_secret;
        $data = [];
        $data['client_id'] = $c_id;
        $data['client_secret'] = $c_secret;
        return $data;
    }

    public function getToken()
    {
        global $c_id;
        global $c_secret;
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        $url = "https://marketplace.walmartapis.com/v3/token";
        $uniqid = uniqid();
        $authorization_key = base64_encode($client_id . ":" . $client_secret);
        $code = "";

        $ch = curl_init();
        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HEADER => false,
            CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => "grant_type=client_credentials",
            CURLOPT_HTTPHEADER => array(
                "WM_SVC.NAME: Walmart Marketplace",
                "WM_QOS.CORRELATION_ID: $uniqid",
                "Authorization: Basic $authorization_key",
                "Accept: application/json",
                "Content-Type: application/x-www-form-urlencoded",
            ),
        );
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($code == 201 || $code == 200) {
            $token = json_decode($response, true);
            return $token['access_token'];
        }
    }

    public function updateItemPrice($SkuId,$newPrice)
    {
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];

        $payload = [
            "sku" => $SkuId,
            "pricing" => [
                [
                    "currentPriceType" => "BASE",
                    "currentPrice" => [
                        "currency" => "USD",
                        "amount" => $newPrice,
                    ],
                ],
            ],
        ];

        $response = Http::withHeaders([
            "WM_SVC.NAME" => "Walmart Marketplace",
            "WM_QOS.CORRELATION_ID" => uniqid(),
            "Authorization" => "Basic " . base64_encode($client_id . ":" . $client_secret),
            "WM_SEC.ACCESS_TOKEN" => $token,
            "Accept" => "application/json",
            "Content-Type" => "application/json",
        ])->put("https://marketplace.walmartapis.com/v3/price", $payload);

        if ($response->status() == 200) {
            $response_data = $response->json();
            return $response_data;
        } else {
            return false;
        }
    }
    
    public function automateBuybox(Request $request){
        $id = $request->user()->id;
        $users = User::where('id', $id)->get();
        foreach ($users as $user) {

        }
        
        global $c_id;
        global $c_secret;
        global $user_id;
        $c_id = $user->client_id;
        $c_secret = $user->client_secret;
      
        $token = $this->getToken();
        $data = $this->getWalmartDetail();
        $client_id = $data['client_id'];
        $client_secret = $data['client_secret'];
        
        
        
        $response = ItemsReport::select(
            'items_reports.id as items_report_id',
            'items_reports.user_id',
            'items_reports.item_sku',
            'items_reports.item_price',
            'items_reports.item_inventory',
            'items_reports.item_buybox_price',
            'items_reports.item_upc',
            'purchases.id as purchase_id',
            'purchases.user_id as purchase_user_id',
            'purchases.item_sku as purchase_item_sku',
            'purchases.po_date',
            'purchases.item_qty',
            'purchases.line_total',
            'purchases.ship_prep_cost',
            'purchases.other_cost',
            'purchases.wfs_cost',
            'purchases.wfs_fee',
            'blacklists.user_id as blacklist_user_id',
            'blacklists.item_sku as blacklist_item_sku'
            )
        ->where('items_reports.user_id', $id)
        ->leftJoin('purchases', 'purchases.item_sku', '=', 'items_reports.item_sku')
        ->leftJoin('blacklists', 'blacklists.item_sku', '=', 'items_reports.item_sku')
        ->where('items_reports.item_inventory', '>=', 1)
        ->whereNull('blacklists.item_sku')
        ->get();
        
        
        
        foreach($response as $value){
                        $item_id = $value->items_report_id;
                        $itemQty = $value->item_qty;
                        $lineTotal = $value->line_total;
                        $shipPrepCost = $value->ship_prep_cost;
                        $otherCost = $value->other_cost;
                        $wfsCost = $value->wfs_cost;
                        $wfsFee = $value->wfs_fee;
                    
                        // Calculate the price per unit (unit price) of the item
                        // Check for division by zero before performing the division
                        $pricePerUnit = ($itemQty != 0) ? ($lineTotal / $itemQty) : 0;
                    
                        // Calculate the total cost of the item including additional costs
                        $totalItemCost = $lineTotal + $shipPrepCost + $otherCost + $wfsCost;
                    
                        // Calculate the cost per item
                        // Check for division by zero before performing the division
                        $perItemCost = ($itemQty != 0) ? ($totalItemCost / $itemQty) : 0;
                        
                        $sku            = $value->item_sku;
                        $myPrice        = $value->item_price;
                        $buyboxPrice    = $value->item_buybox_price;
                        $purchaseCost   = number_format($perItemCost,2);
                        $wfsFee         = number_format($wfsFee,2);
                        $WMTFee         = round($myPrice * 0.15,2);
                        $profitCal      = $myPrice-$perItemCost-$WMTFee-$wfsFee;
                        $profit         = number_format($profitCal,2);
                        
                        if($myPrice>$buyboxPrice && $purchaseCost>0.00 && $purchaseCost>0.01 && $wfsFee>0.00){
                            
                                    $myNewPrice         = $buyboxPrice-0.01;
                                    $newProfitCal       = $myNewPrice-$perItemCost-$WMTFee-$wfsFee;
                                    $newProfit          = number_format($newProfitCal,2);
                                    
                                    if($newProfit>0.01){
                                            
                                                $payload = [
                                                    "sku" => $sku,
                                                    "pricing" => [
                                                        [
                                                            "currentPriceType" => "BASE",
                                                            "currentPrice" => [
                                                                "currency" => "USD",
                                                                "amount" => $myNewPrice,
                                                            ],
                                                        ],
                                                    ],
                                                ];
                                        
                                                $response = Http::withHeaders([
                                                    "WM_SVC.NAME" => "Walmart Marketplace",
                                                    "WM_QOS.CORRELATION_ID" => uniqid(),
                                                    "Authorization" => "Basic " . base64_encode($client_id . ":" . $client_secret),
                                                    "WM_SEC.ACCESS_TOKEN" => $token,
                                                    "Accept" => "application/json",
                                                    "Content-Type" => "application/json",
                                                ])->put("https://marketplace.walmartapis.com/v3/price", $payload);
                                        
                                                if ($response->status() == 200) {
                                                    $response_data = $response->json();
                                                    
                                                    $desiredTimeZone = 'Asia/Dhaka';
                                                    $currentTime = Carbon::now($desiredTimeZone);
                                            
                                                    $result = DB::table('items_reports')
                                                        ->where('id', $item_id)
                                                        ->update([
                                                            "item_price" => $myNewPrice,
                                                            "updated_at" => $currentTime,
                                                        ]);
                                                    
                                                    
                                                } else {
                                                    
                                                }
                                                
                                       
                                    }
                                    
                                    
                                    
                                    
                                
                                
                               
                        }
            
                 
        }
    return back()->with('success', 'Automated Buybox Checked Successfully!');
  
        
    }
    
  public function blackList(Request $request){
    try {
       $id = $request->user()->id;
            $last9999999days = date('Y-m-d', strtotime('-9999999 days'));
            $to_date = date('Y-m-d');
            
            $users = User::all();
            $items = ItemsReport::where('user_id', $id)
            ->where('items_reports.item_inventory', '>=', 1)
            ->get();
            
    
            
            $result = Inventory::select(
                    'blacklists.id as blacklist_id',
                    'blacklists.user_id as blacklist_user_id',
                    'blacklists.item_sku as blacklist_item_sku',
                    'blacklists.item_id as blacklist_item_id',
                    'blacklists.item_owner as blacklist_item_owner',
                    'inventories.avai_sell_qty',
                    'inventories.ship_type',
                    'profits.item_name',
                    'profits.item_image_url',
                    \DB::raw('SUM(profits.sold_qty) as lifetimesell'),
                    'purchases.suplier_name',
                    'purchases.item_qty',
                    'items_reports.user_id as items_reports_user_id',
                    'items_reports.store_name as items_reports_store_name',
                    'items_reports.item_image as items_reports_item_image',
                    'items_reports.item_name as items_reports_item_name',
                    'items_reports.item_inventory',
                    'items_reports.item_id as items_reports_item_id '
                    
                )
                    ->leftJoin('profits', function($join) use ($id, $last9999999days, $to_date) {
                        $join->on('profits.item_sku', '=', 'inventories.item_sku')
                            ->where('profits.user_id', '=', $id)
                            ->whereBetween('profits.order_date', [$last9999999days, $to_date]);
                    })
                    ->leftJoin('purchases', function($join) use ($id) {
                        $join->on('purchases.item_sku', '=', 'inventories.item_sku')
                            ->where('purchases.user_id', '=', $id);
                    })
                    ->rightJoin('blacklists', function($join) use ($id) {
                        $join->on('blacklists.item_sku', '=', 'inventories.item_sku')
                            ->where('blacklists.user_id', '=', $id);
                    })
                    // ->leftJoin('items_reports', 'items_reports.item_id', '=', 'blacklists.item_id')
                    ->leftJoin('items_reports', function($join) {
                            $join->on('items_reports.item_id', '=','blacklists.item_id');
                            
                           
                        })
                    ->where('blacklists.user_id', $id)
                    ->whereNotNull('blacklists.id')
                    ->groupBy(
                        'blacklists.id',
                        'blacklists.user_id',
                        'blacklists.item_sku',
                        'blacklists.item_id',
                        'blacklists.item_owner',
                        'inventories.avai_sell_qty',
                        'inventories.ship_type',
                        'profits.item_name',
                        'profits.item_image_url',
                        'purchases.suplier_name',
                        'purchases.item_qty',
                        'items_reports.user_id',
                        'items_reports.store_name',
                        'items_reports.item_image',
                        'items_reports.item_name',
                        'items_reports.item_inventory',
                        'items_reports.item_id'
                    )->orderBy('blacklists.id','DESC')
                    ->get();
                    
         
       return view('admin.buybox.blacklist', compact('result', 'users','items'));
    } catch (\Exception $e) {
        // Handle the exception, you can log it or return an error response.
         return view('admin.buybox.blacklist')->with('error', 'Try Again!');
    }
}

    
    
    
    
    
    public function addToBlackList(Request $request){
       
        // $blacklist = new blacklist();
        // $blacklist->user_id = $request->user()->id;
        // $blacklist->item_sku = $request->item_sku;
        // $blacklist->item_owner = $request->item_owner;
        // $blacklist->save();
      
        // return back()->with('success', 'Item added to Blacklist!');
       
         
            $selectedValue = $request->input('item_sku_id');
            
            list($itemSku, $itemId) = explode('/', $selectedValue);
            $blacklist = new Blacklist();
          
            $blacklist->user_id = $request->user()->id;
            $blacklist->item_sku = $itemSku;
            $blacklist->item_id = $itemId; 
            $blacklist->item_owner = $request->item_owner;
            $blacklist->save();
        
            return back()->with('success', 'Item added to Blacklist!');
        
        
        
    }
    
    public function deleteBlacklistItem(Request $request, $id)
    {
        // Add the logic to delete the item with the given ID from the database
        DB::table('blacklists')->where('id',$id)->delete();
        
        if ($request->ajax()) {
        return response()->json(['success' => 'Item removed from Blacklist!']);
    } else {
        return back()->with('success', 'Item removed from Blacklist!');
    }
    
       
    }
    

 
}
