<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Imports\WFSImport;
use App\Imports\ImportItemsReport;
use App\Imports\ImportPrice;
use App\Models\Profit;
use App\Models\ImportExcel;
use App\Models\ItemsReport;
use App\Models\CurrentItemPrice;
use App\Models\Purchase;
use Excel;
use DB;

class ImportExcelController extends Controller
{
    public function wfsFee(){
        return view('admin.import.wfs');
    }
    
    
     public function buyboxreport(){
        return view('admin.import.buybox');
    }
    
    

    public function feeWFS(Request $request)
    {

        $user_id = $request->user()->id;
        $valid = $this->validate($request, [
         'select_file'  => 'required|max:3000|mimes:csv,txt'
        ]);

        $data = Excel::toArray(new WFSImport, request()->file('select_file')); 
        \Config::set('excel.import.startRow', 4);
        // $temp = preg_replace("/[^a-zA-Z 0-9]+/", "", $data );
        

       foreach($data as $key => $value){
        for($i = 0; $i < count($value); $i++) {
            
           
            $order_id = $value[$i]['walmartcom_order'];
            $wfsfee = $value[$i]['net_payable'];
            $partner_gtin = $value[$i]['partner_gtin'];

            $order_id = preg_replace("/[^a-zA-Z 0-9]+/", "", $order_id );
            $partner_gtin = preg_replace("/[^a-zA-Z 0-9]+/", "", $partner_gtin );

            // ImportExcel::updateOrCreate(
            //     [
            //         'order_id'    => $order_id,
            //         'user_id'    => $user_id,
            //     ], 
            //     [
            //         'order_id'  => $order_id,
            //         'wfs_fee' => $wfsfee,
            //         'user_id' => $user_id,
            //     ]
            // );

            ImportExcel::where(['order_id'=>$order_id,'user_id'=> $user_id])
            ->update(
                [
                    'gtin'  => $partner_gtin,
                    'order_id'  => $order_id,
                    'wfs_fee' => $wfsfee,
                    'user_id' => $user_id,
                ]
            );

        }
       return back()->with('success', 'Excel Data Imported successfully.');
       }

       
       
       
    }
    
    
     public function boxReport(Request $request)
    {

       $user_id     = $request->user()->id;
       $store_name   = $request->user()->store_name;
       
       
        $valid = $this->validate($request, [
         'select_file'  => 'required|max:3000|mimes:csv,xlsx,txt'
        ]);


        $data = Excel::toArray(new ImportItemsReport, request()->file('select_file')); 
        \Config::set('excel.import.startRow', 2);
        // $temp = preg_replace("/[^a-zA-Z 0-9]+/", "", $data );
        
        
        try {
           if($data[0][0]['item_id']){
              
               
               DB::table('items_reports')->where('user_id', $user_id)->delete();
               
               
                    foreach($data as $key => $value){
                        for($i = 0; $i < count($value); $i++) {
                    
                           $image       = $value[$i]['image'];
                           $item_name   = $value[$i]['item_name'];
                           $sku         = (string) $value[$i]['sku'];
                           $price       = $value[$i]['price_usd'];
                           $inventory   = $value[$i]['inventory'];
                           $buy_box_price = $value[$i]['buy_box_price'];
                           $item_id     = (string) $value[$i]['item_id'];
                           $upc         = (string) $value[$i]['upc'];
                   
                        
                            
                            ItemsReport::updateOrCreate(
                                [
                                    'user_id'    => $user_id,
                                    'item_sku'   => $sku,
                                ], 
                                [
                                    'user_id'       => $user_id,
                                    'store_name'     =>$store_name,
                                    'item_image'    => $image,
                                    'item_name'     => $item_name,
                                    'item_sku'      => $sku,
                                    'item_price'    => $price,
                                    'item_inventory' => $inventory,
                                    'item_buybox_price' => $buy_box_price,
                                    'item_id'       => $item_id,
                                    'item_upc'      => $upc,
                                    'updated_at'    => null,
                                    
                                    
                                ]
                            );
                    
                    
                    }
               
               }
            return back()->with('success', 'Excel Data Imported successfully.');
            
        }

        } catch (\Exception $e) {
                return back()->with('error', 'Invalid File!!');
            
        }
       
    }
    
    


    public function manageFee(Request $request){

        $user_id = $request->user()->id;

        $response = DB::table('import_excels')
        ->where('user_id', $user_id)
        ->orderBy('item_name','ASC')
        ->get();
        
        return view('admin.import.index', compact('response'));
    }




    public function update(Request $request)
       {
           if($request->ajax())
           {
               $Id = $request->Id;
               $ldate = date('Y-m-d H:i:s');


               $fieldName = $request->fieldName;
               $values = $request->values;
               $result = DB::table('import_excels')
                 ->where('id', $Id)
                 ->update([
                     $fieldName => $values,
                     'updated_at' =>  $ldate
                    
                    ]);
           }
   
          
           
       }
       
       public function payReport(){
           
           
           return view('admin.import.payment');
       }
       
       public function uploadPayReport(Request $request){
           
           
           $user_id = $request->user()->id;
        $valid = $this->validate($request, [
         'select_file'  => 'required|max:3000|mimes:csv,xlsx,txt'
        ]);


        $data = Excel::toArray(new ImportItemsReport, request()->file('select_file')); 
        \Config::set('excel.import.startRow', 2);
        
        foreach($data as $key => $value){
                        for($i = 0; $i < count($value); $i++) {
                        return $value;
                    
                        }
            
        }
       }
       
       
        public function itemPrice(){
           
           return view('admin.import.itemprice');
       }
       
       public function uploadItemPrice(Request $request){
           
         $user_id = $request->user()->id;
        $valid = $this->validate($request, [
         'select_file'  => 'required|max:3000|mimes:csv,xlsx,txt'
        ]);

        $data = Excel::toArray(new ImportPrice, request()->file('select_file')); 
        \Config::set('excel.import.startRow', 1);
        // $temp = preg_replace("/[^a-zA-Z 0-9]+/", "", $data );
        
        
        
       foreach($data as $key => $value){
        for($i = 0; $i < count($value); $i++) {
            
           
            $item_id        = $value[$i]['item_id'];
            $upc            = trim($value[$i]['upc']);
            $price          = $value[$i]['price'];
            $upc2           = (string) $upc;
            
            Purchase::where(['p_upc'=> $upc2 ,'user_id'=> $user_id])
            ->update(
                [
                    'new_price'  => $price,
                ]
            );
                            
                            
        }
       return back()->with('success', 'Excel Data Imported successfully.');
       }
       
        
       }
       
}
