<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Profit;
use App\Models\Inventory;
use App\Models\Product;
use DB;
use App\Models\BrowserStat;
use LaravelDaily\LaravelCharts\Classes\LaravelChart;

class AdminPanelController extends Controller
{

    public function Filter(Request $request){
      
        if($request->ajax())
        {
            $values = $request->values;
            DB::table('unit')
                    ->insert([
                    'unit_name'               => 3,
                    ]);

        }

    }
    public function dashboard(Request $request){
        $user_id = $request->user()->id;

        $chart_options = [
            'chart_title'           => 'Sales Amount',
            'report_type'           => 'group_by_date',
            'model'                 => 'App\Models\Profit',
            'group_by_field'        => 'order_date',
            'group_by_period'       => 'day',
            'aggregate_function'    => 'sum',
            'aggregate_field'       => 'walmart_price',
            'where_raw'             => 'user_id ='.$user_id,
            'chart_type'            => 'line',
            'chart_color'           => '13,89,141',
            'filter_field'          => 'order_date',
            'filter_days'           => 30,
            'chart_height'          => '100px',
            'date_format'           => 'M-d',
           
        ];

        $chart1 = new LaravelChart($chart_options);
        

        $chart_options = [
            'chart_title'           => 'Monthly Sales',
            'report_type'           => 'group_by_date',
            'model'                 => 'App\Models\Profit',
            'group_by_field'        => 'order_date',
            'group_by_period'       => 'month',
            'aggregate_function'    => 'sum',
            'aggregate_field'       => 'walmart_price',
            'where_raw'             => 'user_id ='.$user_id,
            'chart_type'            => 'line',
            'chart_color'           => '36, 206, 130',
            'chart_height'          => '100px',
            'date_format'           => 'M-Y',
            
        ];

        
        $chart2 = new LaravelChart($chart_options);

        $chart_options = [
            'chart_title'           => 'Sales Qty',
            'report_type'           => 'group_by_date',
            'model'                 => 'App\Models\Profit',
            'group_by_field'        => 'order_date',
            'group_by_period'       => 'day',
            'aggregate_function'    => 'sum',
            'aggregate_field'       => 'sold_qty',
            'where_raw'             => 'user_id ='.$user_id,
            'chart_type'            => 'line',
            'chart_color'           => '200,50,188',
            'filter_field'          => 'order_date',
            'filter_days'           => 30,
            'chart_height'          => '100px',
            'date_format'           => 'M-d',
        ];

        $chart3 = new LaravelChart($chart_options);

    

        $last7days = date('Y-m-d');
        $last14days = date('Y-m-d', strtotime('-14 days'));
        $last30days = date('Y-m-d', strtotime('-30 days'));

        $last90days = date('Y-m-d', strtotime('-90 days'));
        
        $thisYear = date('Y-01-01'); // Set to January 1st of the current year
        $to_date = date('Y-m-d');   // Current date
        
        $to_date   = date('Y-m-d');

       

     
    

        $todaySales = Profit::where('user_id',$user_id)
        ->whereDate('order_date',$to_date)
        ->sum('walmart_price');
        
       

        $response14 = Profit::where('user_id',$user_id)
        ->whereBetween('order_date', [$last14days, $to_date])
        ->sum('walmart_price');

        $response30 = Profit::where('user_id',$user_id)
        ->whereBetween('order_date', [$last30days, $to_date])
        ->sum('walmart_price');
        
         $responselifeTime = Profit::where('user_id',$user_id)
        ->whereBetween('order_date', [$thisYear, $to_date])
        ->sum('walmart_price');


  
       







    $topSelling     = Inventory::select(\DB::raw('profits.item_sku,profits.item_name,profits.sold_qty,inventories.avai_sell_qty, SUM(profits.walmart_price) as walmartPrice, SUM(profits.sold_qty) as soldQty'))
                ->leftjoin('profits','profits.item_sku','=','inventories.item_sku') 
                ->where('profits.user_id',$user_id)
                ->whereBetween('profits.order_date', [$last30days, $to_date])
                ->groupBy('profits.item_sku')
                ->groupBy('profits.item_name')
                ->groupBy('profits.sold_qty')
                ->groupBy('inventories.avai_sell_qty')
                ->take(10)
                ->get();
                
                

        $result = \DB::table('profits')
        ->where('user_id','=','4')
        ->orderBy('order_date', 'ASC')
        ->get();


     $last77days = date('Y-m-d', strtotime('-7 days'));
     $last144days = date('Y-m-d', strtotime('-14 days'));
     $last300days = date('Y-m-d', strtotime('-30 days'));
     $last900days = date('Y-m-d', strtotime('-90 days'));

     $to_date   = date('Y-m-d');

     $response77 = Inventory::select(\DB::raw('profits.item_sku,profits.item_name,profits.item_image_url,inventories.avai_sell_qty,inventories.ship_type, SUM(profits.sold_qty) as last77daysqty'))
     ->leftjoin('profits','profits.item_sku','=','inventories.item_sku') 
     ->where('profits.user_id',$user_id)
     ->whereBetween('profits.order_date', [$last77days, $to_date])
     ->groupBy('profits.item_sku')
     ->groupBy('profits.item_name')
     ->groupBy('profits.item_image_url')
     ->groupBy('inventories.ship_type')
     ->groupBy('inventories.avai_sell_qty')
     ->where('inventories.avai_sell_qty','<=',20)
     ->get();


     $response144 = Inventory::select(\DB::raw('profits.item_sku,profits.item_name,profits.item_image_url,inventories.avai_sell_qty,inventories.ship_type, SUM(profits.sold_qty) as last144daysqty'))
     ->leftjoin('profits','profits.item_sku','=','inventories.item_sku') 
     ->where('profits.user_id',$user_id)
     ->whereBetween('profits.order_date', [$last144days, $to_date])
     ->groupBy('profits.item_sku')
     ->groupBy('profits.item_image_url')
     ->groupBy('profits.item_name')
     ->groupBy('inventories.ship_type')
     ->groupBy('inventories.avai_sell_qty')
     ->where('inventories.avai_sell_qty','<=',15)
     ->get();

     $response300 = Inventory::select(\DB::raw('profits.item_sku,profits.item_name,profits.item_image_url,inventories.avai_sell_qty,inventories.ship_type, SUM(profits.sold_qty) as last300daysqty'))
     ->leftjoin('profits','profits.item_sku','=','inventories.item_sku') 
     ->where('profits.user_id',$user_id)
     ->whereBetween('profits.order_date', [$last300days, $to_date])
     ->groupBy('profits.item_sku')
     ->groupBy('profits.item_name')
     ->groupBy('profits.item_image_url')
     ->groupBy('inventories.ship_type')
     ->groupBy('inventories.avai_sell_qty')
     ->where('inventories.avai_sell_qty','<=',15)
     ->get();

     $response900 = Inventory::select(\DB::raw('profits.item_sku,profits.item_name,profits.item_image_url,inventories.avai_sell_qty,inventories.ship_type, SUM(profits.sold_qty) as last900daysqty'))
     ->leftjoin('profits','profits.item_sku','=','inventories.item_sku') 
     ->where('profits.user_id',$user_id)
     ->whereBetween('profits.order_date', [$last900days, $to_date])
     ->groupBy('profits.item_sku')
     ->groupBy('profits.item_name')
     ->groupBy('profits.item_image_url')
     ->groupBy('inventories.ship_type')
     ->groupBy('inventories.avai_sell_qty')
     ->where('inventories.avai_sell_qty','<=',15)
     ->get();



     $dataAnalize2 = array_merge($response77->toArray(), $response144->toArray(),$response300->toArray(),$response900->toArray());



     $result2 = collect($dataAnalize2)
     ->groupBy('item_sku')
     ->map(function ($item) {
         return array_merge(...$item->toArray());
     })
     ->values()
     ->toArray();
   

        return view('admin.index',compact('chart1','chart2','chart3','topSelling'))
        ->with('todaySales',$todaySales)
        ->with('last14daySales',$response14)
        ->with('last30daySales',$response30)
        ->with('responselifeTime',$responselifeTime)
        ->with('topSelling', $topSelling)
        ->with('result2',$result2);
    }

    public function chart(){
        $result = \DB::table('profits')
                    ->where('user_id','=','4')
                    ->orderBy('order_date', 'ASC')
                    ->get();
        return response()->json($result);

    }
    
        
    public function getTodaySales(Request $request)
        {
            $user_id = $request->user()->id;
            $to_date = date('Y-m-d');
        
            $todaySales = Profit::where('user_id', $user_id)
                ->whereDate('order_date', $to_date)
                ->selectRaw('SUM(walmart_price) as total_walmart_price, SUM(sold_qty) as total_sold_qty')
                ->first();
        
            return response()->json(['todaySales' => $todaySales]);
        }

}
