<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;

class AbsentController extends Controller
{
    public function addAbsent(Request $request){
        $employees = DB::table('employees')
        ->join('designations','designations.id','=','employees.designation')
        ->where(['employees.id_card_no'=>$request->employeeId])
        ->select('employees.*','designations.designation_name')->get();

    	
    	if($employees->isEmpty()){
            return view('admin.absent.add_absent');
        }else{
            return view('admin.absent.add_absent')
            ->with('employees', $employees);
           
        }
    }

    public function saveAbsent(Request $request){
         $condition = ['absents.employee_id'=>$request->employee_id,'absents.salary_month'=>$request->salary_month,'absents.salary_year'=>$request->salary_year];

        $row = DB::table('absents')
        ->where($condition)->get();
 
          if($row->isEmpty()) {
            $data = request()->except(['_token']);
            $row = DB::table('absents')->insert($data);
            return redirect()->back()->with('success','Add Successfully!!');
        } else {
            $condition = ['absents.employee_id'=>$request->employee_id,'absents.salary_month'=>$request->salary_month,'absents.salary_year'=>$request->salary_year];
           
            DB::table('absents')
            ->where($condition)
            ->update([
                'employee_id'       => $request->employee_id,
                'dates'             => $request->dates,
                'abs_total_days'    => $request->abs_total_days,
                'salary_month'      => $request->salary_month,
                'salary_year'       => $request->salary_year
            ]);

            return redirect()->back()->with('success','Update Successfully!!');
        }
        
    }
}
